//-----------------------------------------------------------------------------
//
//  $Logfile:: /Quake 2 Engine/Sin/code/game/ctf_turret.cpp                    $
// $Revision:: 2                                                              $
//   $Author:: Markd                                                          $
//     $Date:: 2/19/99 7:49p                                                  $
//
// Copyright (C) 1997 by Ritual Entertainment, Inc.
// All rights reserved.
//
// This source is may not be distributed and/or modified without
// expressly written permission by Ritual Entertainment, Inc.
//
// $Log:: /Quake 2 Engine/Sin/code/game/ctf_turret.cpp                        $
// 
// 2     2/19/99 7:49p Markd
// implemented turret for CTF
// 
// 1     2/19/99 6:03p Markd
// 
// DESCRIPTION:
// CTF turret, usable turret
// 

#include "g_local.h"
#include "vehicle.h"
#include "ctf_turret.h"
#include "heligun.h"


CLASS_DECLARATION( Vehicle, CTFTurret, "ctf_turret" );

ResponseDef CTFTurret::Responses[] =
	{
	   { &EV_Use,						      ( Response )CTFTurret::DriverUse },
		{ NULL, NULL }
	};

CTFTurret::CTFTurret()
	{
   takedamage = DAMAGE_YES;
	setModel( "ctf_turret.def" );
   setOrigin( origin - Vector( "0 0 30") );
	}

void CTFTurret::DriverUse
	(
	Event *ev
	)

	{
   Entity * old_driver;

   old_driver = driver;
   Vehicle::DriverUse( ev );
   if ( old_driver != driver )
      {
      if ( driver )
         {
         hideModel();
         }
      else
         {
         showModel();
         }
      }
	}

#define MAX_PITCH 45
float CTFTurret::SetDriverPitch
	(
	float pitch
	)
   {
   if ( pitch > 180 )
      {
      if ( pitch < 360 - MAX_PITCH )
         {
         pitch = 360 - MAX_PITCH;
         }
      }
   else
      {
      if ( pitch > MAX_PITCH )
         {
         pitch = MAX_PITCH;
         }
      if ( pitch < -MAX_PITCH )
         {
         pitch = -MAX_PITCH;
         }
      }
   return pitch;
   }


CLASS_DECLARATION( HeliGun, CTFTurretGun, "ctf_weapon_turretgun" );

ResponseDef CTFTurretGun::Responses[] =
	{
		{ NULL, NULL }
	};

CTFTurretGun::CTFTurretGun
   (
   )
	
   {
	SetModels( "ctf_turretgun.def", "view_ctf_turretgun.def" );
	}

void CTFTurretGun::Shoot
	(
	Event *ev
	)

	{
   FireBullets( 1, "20 20 20", 16, 28, DAMAGE_BULLET, MOD_HELIGUN, false );
	NextAttack( 0 );
	}

